/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.nio.file.Path;
import java.util.regex.Pattern;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.MySQL;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.connections.ServiceChecker;
import net.skinsrestorer.shared.utils.log.SRLogger;

public class SharedMethods {
    private SharedMethods() {
    }

    public static void allowIllegalACFNames() {
        try {
            Class<?> patternClass = Class.forName("net.skinsrestorer.shadow.aikar.commands.ACFPatterns");
            ReflectionUtil.setObject(patternClass, null, "VALID_NAME_PATTERN", Pattern.compile("(.*?)"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runServiceCheck(MojangAPI mojangAPI, SRLogger log) {
        ServiceChecker checker = new ServiceChecker();
        checker.setMojangAPI(mojangAPI);
        checker.checkServices();
        ServiceChecker.ServiceCheckResponse response = checker.getResponse();
        if (response.getWorkingUUID().get() == 0 || response.getWorkingProfile().get() == 0) {
            log.info("\u00a7c[\u00a74Critical\u00a7c] ------------------[\u00a72SkinsRestorer \u00a7cis \u00a7c\u00a7l\u00a7nOFFLINE\u00a7r\u00a7c] -------------------------");
            log.info("\u00a7c[\u00a74Critical\u00a7c] \u00a7cPlugin currently can't fetch new skins due to blocked connection!");
            log.info("\u00a7c[\u00a74Critical\u00a7c] \u00a7cSee https://skinsrestorer.net/firewall for steps to resolve your issue!");
            log.info("\u00a7c[\u00a74Critical\u00a7c] ----------------------------------------------------------------------");
        }
    }

    public static boolean initStorage(SRLogger srLogger, SkinStorage skinStorage, Path dataFolder) {
        if (Config.MYSQL_ENABLED) {
            try {
                MySQL mysql = new MySQL(srLogger, Config.MYSQL_HOST, Config.MYSQL_PORT, Config.MYSQL_DATABASE, Config.MYSQL_USERNAME, Config.MYSQL_PASSWORD, Config.MYSQL_MAX_POOL_SIZE, Config.MYSQL_CONNECTION_OPTIONS);
                mysql.connectPool();
                mysql.createTable();
                skinStorage.setMysql(mysql);
            }
            catch (Exception e) {
                srLogger.severe("\u00a7cCan't connect to MySQL! Disabling SkinsRestorer.", e);
                return false;
            }
        } else {
            skinStorage.loadFolders(dataFolder);
        }
        skinStorage.setInitialized(true);
        return true;
    }
}

